import { handleActions } from "redux-actions";
import {
    changeTrainingSamplesType,
    closeCreateSampleModal,
    closeMetricsModal,
    closeStatsModal,
    failedGettingTrainingSamples,
    openCreateSampleModal,
    openMetricsModal,
    openStatsModal,
    openUpdateSampleModal,
    receivedTrainingSamples,
    requestTrainingSamples,
} from "./actions";
import _ from "lodash";

function obtainMessage(error) {
    if (_.isString(error)) {
        return error;
    }
    if (_.isObject(error)) {
        if (error.obj) {
            return error.obj.message || "Unknown error";
        } else {
            return error;
        }
    }
}

export const trainingSamplesReducer = handleActions(
    {
        // training samples loading
        [requestTrainingSamples]: (state) => ({
            ...state,
            loaded: false,
            failed: false,
        }),
        [receivedTrainingSamples]: (state, { payload }) => ({
            ...state,
            samples: payload,
            loaded: true,
            failed: false,
        }),
        [failedGettingTrainingSamples]: (state, { payload }) => ({
            ...state,
            failed: true,
            message: obtainMessage(payload),
        }),

        // sample creation modal
        [openCreateSampleModal]: (state) => ({
            ...state,
            modals: { ...state.modals, createSample: true, newModel: true },
        }),
        [openUpdateSampleModal]: (state) => ({
            ...state,
            modals: { ...state.modals, createSample: true, newModel: false },
        }),
        [closeCreateSampleModal]: (state) => ({
            ...state,
            modals: { ...state.modals, createSample: false },
        }),

        // stats modal
        [openStatsModal]: (state) => ({
            ...state,
            modals: { ...state.modals, showStats: true },
        }),
        [closeStatsModal]: (state) => ({
            ...state,
            modals: { ...state.modals, showStats: false },
        }),

        // metrics modal
        [openMetricsModal]: (state) => ({
            ...state,
            modals: { ...state.modals, showMetrics: true },
        }),
        [closeMetricsModal]: (state) => ({
            ...state,
            modals: { ...state.modals, showMetrics: false },
        }),

        [changeTrainingSamplesType]: (state, { payload }) => ({
            ...state,
            type: payload,
        }),
    },
    {
        loaded: false,
        failed: false,
        samples: {},
        type: "forNewModel",
        modals: { createSample: false, showStats: false, showMetrics: false },
    }
);
