import { createSelector } from "reselect";
import qs from "query-string";

const getTrainingSamples = (state) => state.trainingSamples;
const getLocation = (state) => state.router.location;
const getTrainingSampleIdFromSearch = (location) => qs.parse(location.search).sample;

export const getTrainingSamplesState = createSelector([getTrainingSamples], (data) => data);

export const getSelectedTrainingSampleId = createSelector([getLocation], getTrainingSampleIdFromSearch);

export const getSelectedTrainingSample = createSelector([getLocation, getTrainingSamples], (location, samples) => {
    const sampleId = getTrainingSampleIdFromSearch(location);
    return samples.samples[samples.type].filter((each) => each.id === sampleId)[0];
});
