import React from "react";
import { connect } from "react-redux";
import { useTranslation } from "react-i18next";
import { toString as _toString, isEmpty } from "lodash";
import { Button } from "@lib/components/lego";
import robotForbiddenPic from "../images/robot_forbidden.svg";
import robotBrokenPic from "../images/robot_broken.svg";
import { getBetaState } from "../selectors";
import Refresh from "./Refresh";
import { getCurrentUserLogin } from "./cookie";

function getLabAccessLink(roleType) {
    const currentLogin = getCurrentUserLogin();
    const login = !isEmpty(currentLogin) ? currentLogin + "@" : "";

    return `https://idm.yandex-team.ru/#rf-role=DvvD3iom#${login}crypta/lab/${roleType};;;,rf-expanded=DvvD3iom,rf=1`;
}

const ACCESS_LINKS = {
    Audiences: getLabAccessLink("audiences"),
};

const DefaultErrorPage = (props) => {
    const { retry, errorMessage } = props;

    const retryable = retry || (() => null);

    return (
        <div className="info-page">
            <img className="robotPic" alt="" src={robotBrokenPic} />
            <p> {_toString(errorMessage) || ""} </p>
            {retry && <Refresh action={retryable} />}
        </div>
    );
};

const ForbiddenErrorPage = connect((state) => ({
    beta: getBetaState(state),
}))((props) => {
    const { pageType, beta } = props;

    const { t } = useTranslation("errors");

    const url = ACCESS_LINKS[pageType].replace("idm.", "idm." + (beta ? "test." : ""));

    return (
        <div className="info-page">
            <img className="robotPic" alt="" src={robotForbiddenPic} />

            <p>
                {t("chapterForbidden")}
                {t(`accessLinkTitle.${pageType.toLowerCase()}`) + "\n"}
            </p>

            <Button
                view="action"
                type="link"
                size="s"
                url={url}
                target="_blank"
                onClick={() => window.yaCounter47167362.reachGoal("request" + pageType + "Role")}
            >
                {t("requestAccess")}
            </Button>
        </div>
    );
});

export { ForbiddenErrorPage };
export default DefaultErrorPage;
