import React from "react";
import PropTypes from "prop-types";
import DefaultErrorPage from "./Errors";

const Failable = (props) => {
    const { failed, retry, errorMessage } = props;

    if (failed) {
        return <DefaultErrorPage retry={retry} errorMessage={errorMessage} />;
    } else {
        return <React.Fragment>{props.children}</React.Fragment>;
    }
};

Failable.propTypes = {
    failed: PropTypes.bool.isRequired,
    retry: PropTypes.func,
    errorMessage: PropTypes.string,
};

Failable.defaultProps = {
    failed: false,
};

export default Failable;
