import React from "react";
import copyToClipboard from "@lib/utils/clipboard";
import "./Id.scss";

const Id = (props) => {
    const { value, copyable, className } = props;
    const onClick = copyable ? () => copyToClipboard(value) : () => null;
    return (
        <span className={`Id ${copyable && "Copyable"} ${className}`} onClick={onClick}>
            {value}
        </span>
    );
};

export default Id;
