import React from "react";
import { useDispatch } from "react-redux";
import { useTranslation } from "react-i18next";
import FontAwesome from "react-fontawesome";
import { Button } from "@lib/components/lego";
import copyToClipboard from "@lib/utils/clipboard";
import { addInfoNotification } from "./notifications/notificationsState";

import "../segments/utils/style.scss";

const LabLink = (props) => {
    const { search } = props;
    const { t } = useTranslation("utils");
    const dispatch = useDispatch();

    const url = location.origin + location.pathname + "?" + search;

    const handleCopyLink = () => {
        copyToClipboard(url);
        dispatch(addInfoNotification(t("linkCopied")));
    };

    return (
        <Button view="clear" size="s" className="LabLink" onClick={handleCopyLink} title={t("copyLink")}>
            <FontAwesome name="link" />
        </Button>
    );
};

export default LabLink;
