import React from "react";
import PropTypes from "prop-types";
import { useTranslation } from "react-i18next";

import "./LabModalHeader.scss";

// TODO shrink sizes
const LabModalHeader = (props) => {
    const { title, info, hasClose, onClose } = props;

    const { t } = useTranslation("common");

    return (
        <div className="LabModalHeader-container">
            <span className="LabModalHeader-title">{title}</span>
            <span className="LabModalHeader-right">
                {info && <span className="LabModalHeader-info">{info}</span>}
                {hasClose && (
                    <span className="LabModalHeader-close" onClick={onClose} title={t("actions.close")}>
                        ⨉
                    </span>
                )}
            </span>
        </div>
    );
};

LabModalHeader.propTypes = {
    title: PropTypes.string.isRequired,
    info: PropTypes.any,
    hasClose: PropTypes.bool,
    onClose: PropTypes.func,
};

LabModalHeader.defaultProps = {
    hasClose: false,
};

export default LabModalHeader;
