import React, { Component } from "react";
import * as moment from "moment";
import "moment/locale/ru";
import { connect } from "react-redux";
import { getNowState } from "../selectors";

class SimpleDate extends Component {
    render() {
        moment.locale(this.props.lang);
        let value = moment.unix(this.props.value);
        if (this.props.value === 0) {
            value = moment.invalid();
        }
        return <span className={this.props.className}>{value.fromNow()}</span>;
    }
}

export default connect((state) => ({ now: getNowState(state) }))(SimpleDate);
