import React from "react";

import Link from "@lib/components/link";

import "./User.scss";

const getUserPic = (login) => {
    return `//center.yandex-team.ru/user/avatar/${login}/100/square`;
};

const User = (props) => {
    const { login } = props;
    const src = getUserPic(login);
    const style = { backgroundImage: `url(${src})` };

    return (
        <Link className="UserLink" href={`https://staff.yandex-team.ru/${login}`} target="_blank">
            <span key="picture" className="UserPicture" style={style} />
            <span key="login" className="UserLogin">
                {login}
            </span>
        </Link>
    );
};

export default User;
