import React from "react";
import { connect } from "react-redux";
import { isEmpty } from "lodash";
import { useTranslation } from "react-i18next";
import { getSrcTableColumnsState } from "../selectors";

import "./ValidableYtPath.scss";

const ValidableYtPath = connect((state) => ({
    srcYtColumns: getSrcTableColumnsState(state),
}))((props) => {
    const { srcYtColumns } = props;
    const srcYtTableValid = !isEmpty(srcYtColumns.columns);

    const { t } = useTranslation("common");

    const statusMessages = {
        BAD_PATH: t("tableWarnings.corrupted"),
        CANT_READ: t("tableWarnings.noAccess"),
        NOT_FOUND: t("tableWarnings.notFound"),
        NOT_TABLE: t("tableWarnings.notTable"),
        NO_SCHEMA: t("tableWarnings.badSchema"),
        NO_COLUMNS: t("tableWarnings.noColumns"),
        NO_COLUMNS_WITH_VALID_ID_TYPES: t("tableWarnings.noColumnsWithValidIdTypes"),
        NOT_ENOUGH_ROWS: t("tableWarnings.notEnoughRows"),
    };

    let validationStyleSuffix;
    if (srcYtColumns.intact) {
        validationStyleSuffix = "";
    } else if (srcYtColumns.loading) {
        validationStyleSuffix = "-in-progress";
    } else if (!srcYtTableValid) {
        validationStyleSuffix = "-invalid";
    } else {
        validationStyleSuffix = "-valid";
    }

    // Consider table valid if API response 5xx
    return (
        <div className={"ValidableYtPath" + validationStyleSuffix}>
            {props.children}

            <div className="ValidableYtPath-warning">
                {srcYtColumns.loading ? (
                    t("tableWarnings.validating")
                ) : !srcYtTableValid && srcYtColumns.statusCode !== "UNKNOWN" ? (
                    statusMessages[srcYtColumns.statusCode]
                ) : (
                    <div />
                )}
            </div>
        </div>
    );
});

export default ValidableYtPath;
