import React from "react";

import Link from "@lib/components/link";
import FontAwesome from "react-fontawesome";

import "./YtPath.scss";

export function getYtUrl(tablePath, proxy = "hahn") {
    return `https://yt.yandex-team.ru/${proxy}/?page=navigation&path=${tablePath}`;
}

function YtPathLink(props) {
    const { tablePath, linkTitle } = props;
    const url = getYtUrl(tablePath);
    return (
        <Link href={url} target="_blank" className="YtPath">
            <FontAwesome name="external-link" title={linkTitle} />
        </Link>
    );
}

export default YtPathLink;
