import React, { useEffect } from "react";
import { useDispatch } from "react-redux";
import { GreenDot } from "@lib/components/color-dot";

import "./style.scss";
import { removeNotification } from "./notificationsState";

const SuccessNotificationBody = (props) => {
    const { message, id } = props;

    const dispatch = useDispatch();

    useEffect(() => {
        setTimeout(() => dispatch(removeNotification(id)), 3000 + Math.floor(Math.random() * 10));
    }, []);

    return (
        <div className="SuccessNotificationBody">
            <div className="SuccessNotificationBody-message">
                <GreenDot />
                <span className="SuccessNotificationBody-message-text">OK {message}</span>
            </div>
        </div>
    );
};

export default SuccessNotificationBody;
