import { getCurrentUserLogin } from "./cookie";
import { isEmpty } from "lodash";

export function isAuthor(login) {
    return getCurrentUserLogin() === login;
}

export function isResponsible(responsibles) {
    return responsibles && responsibles.map((x) => x.split("@", 1)[0].toLowerCase()).includes(getCurrentUserLogin());
}

export function allowedToEditSegment(segment) {
    return !isEmpty(segment) && (isAuthor(segment.author) || isResponsible(segment.responsibles));
}
