import React, { useState } from "react";
import FontAwesome from "react-fontawesome";

import "./styles.scss";

const SegmentFormPropertyTooltip = (props) => {
    const { text } = props;

    const [visible, setVisible] = useState(false);

    return (
        <span className="SegmentFormPropertyTooltip">
            <FontAwesome
                name="question-circle"
                onMouseOver={() => setVisible(true)}
                onMouseOut={() => setVisible(false)}
            />
            <div className={"SegmentFormPropertyTooltipContent" + (visible ? "" : "-hidden")}>{text}</div>
        </span>
    );
};

export default SegmentFormPropertyTooltip;
