import { createAction } from "redux-actions";

export const requestYtTableColumns = createAction("request yt table columns");
export const receiveYtTableColumns = createAction("receive yt table columns");
export const failYtTableColumns = createAction("fail yt table columns");
export const resetYtTableColumns = createAction("reset yt table columns");
export const setActiveColumn = createAction("set active column");

const CODES = [
    "BAD_PATH",
    "CANT_READ",
    "NOT_FOUND",
    "NOT_TABLE",
    "NO_SCHEMA",
    "NO_COLUMNS",
    "NO_COLUMNS_WITH_VALID_ID_TYPES",
    "NOT_ENOUGH_ROWS",
];

export function validateTablePath(api, path, minRows = null) {
    return (dispatch) => {
        dispatch(requestYtTableColumns());

        return api
            .then((api) => api.apis.lab.getLabSegmentColumnsWithIdTypes({ path: path, minRows: minRows }))
            .then((response) => {
                dispatch(receiveYtTableColumns(response.obj));
            })
            .catch((error) => {
                let errorResponse = error.response;
                let code = errorResponse && errorResponse.obj ? errorResponse.obj.code : "";

                let is_5xx = 500 <= errorResponse.status && errorResponse.status <= 504;

                if (is_5xx || !CODES.includes(code)) {
                    code = "UNKNOWN";
                }

                dispatch(failYtTableColumns(code));
            });
    };
}
