import { handleActions } from "redux-actions";
import {
    failYtTableColumns,
    receiveYtTableColumns,
    requestYtTableColumns,
    resetYtTableColumns,
    setActiveColumn,
} from "./utilsActions";

const INITIAL_TABLE_PATH_VALIDATION_STATE = {
    path: null,
    loading: false,
    columns: [],
    intact: true,
    statusCode: null,
    activeColumn: null,
};

export const utilsReducer = handleActions(
    {
        [requestYtTableColumns]: (state) => ({
            ...state,
            path: null,
            columns: [],
            statusCode: null,
            loading: true,
            intact: false,
        }),
        [receiveYtTableColumns]: (state, { payload }) => ({
            ...state,
            loading: false,
            columns: payload.columns,
            statusCode: payload ? "OK" : "CANT_READ",
            activeColumn: payload
                ? payload.columns.find((element, array, index) => element.name === state.activeColumn)
                    ? state.activeColumn
                    : payload.columns[0].name
                : null,
        }),
        [failYtTableColumns]: (state, { payload }) => ({
            ...state,
            loading: false,
            columns: [],
            activeColumn: null,
            statusCode: payload,
        }),
        [setActiveColumn]: (state, { payload }) => ({
            ...state,
            activeColumn: payload,
        }),
        [resetYtTableColumns]: () => INITIAL_TABLE_PATH_VALIDATION_STATE,
    },
    INITIAL_TABLE_PATH_VALIDATION_STATE
);
