import React, { useRef } from "react";

import "./index.scss";

function easeInOutSine(x) {
    return -(Math.cos(Math.PI * x) - 1) / 2;
}

function computeOpacity(scroll) {
    return easeInOutSine(Math.max(Math.min(scroll / 40.0, 1.0), 0.0));
}

function Body(props) {
    const mainRef = useRef(null);
    const shadowRef = useRef(null);
    const onScroll = () => {
        shadowRef.current.style = `opacity: ${computeOpacity(mainRef.current.scrollTop)};`;
    };
    return (
        <div className="Body" ref={mainRef} onScroll={onScroll}>
            <div key="shadow" ref={shadowRef} className="overscroll-shadow" />
            {props.children}
        </div>
    );
}

export default Body;
