import React from "react";
import ReactDOMServer from "react-dom/server";
import FontAwesome from "react-fontawesome";
import { isUndefined } from "lodash";
import copyToClipboard from "@lib/utils/clipboard";

import "./index.scss";

const elementStyle = {
    backgroundColor: "#fff",
    borderRadius: "6px",
    padding: "16px",
    border: "1px #eee solid",
};
const headerStyle = { fontSize: "24px", marginBottom: "10px" };
const descriptionStyle = { color: "#666" };
const logoStyle = { float: "right" };

function embeddable(header, description, elements) {
    const embeddable = (
        <div style={elementStyle}>
            <div style={logoStyle}>
                <img src="https://yastatic.net/q/logoaas/v1/Яндекс.Крипта.svg" alt="Crypta Logo" />
            </div>

            {!isUndefined(header) && <div style={headerStyle}>{header}</div>}
            {!isUndefined(description) && <div style={descriptionStyle}>{description}</div>}
            <br />

            <div>{elements}</div>
        </div>
    );

    return `<#${ReactDOMServer.renderToStaticMarkup(embeddable)}#>`;
}

function EmbeddableCopyable(props) {
    const { header, description } = props;

    const value = embeddable(header, description, props.children);

    return (
        <span className="EmbeddableCopyable">
            <FontAwesome name="file-code-o" onClick={() => copyToClipboard(value)} />
        </span>
    );
}

export default EmbeddableCopyable;
export { embeddable };
