import React, { Component } from "react";

import "@yandex-int/error-counter/dist/interfaceWithoutRum";
import "@yandex-int/error-counter/dist/implementation";
import "@yandex-int/error-counter/dist/filters";
import "@yandex-int/error-counter/dist/sendWithoutRum";
import "@yandex-int/error-counter/dist/logError";
import "@yandex-int/error-counter/dist/logAjaxError";

import "./index.scss";

class ErrorBoundary extends Component {
    state = {};

    static getDerivedStateFromError() {
        return { hasError: true };
    }

    componentDidCatch(error, errorInfo) {
        // TODO send to error-booster
    }

    render() {
        if (this.state.hasError) {
            return <React.Fragment />;
        } else {
            return this.props.children;
        }
    }
}

export function initializeErrorCounter() {
    Ya.Rum.initErrors({
        project: "crypta",
    });
}

export default ErrorBoundary;
