import React from "react";
import { useTranslation } from "react-i18next";

import "./index.scss";

function LanguageSelect(props) {
    const { onChange } = props;
    const { i18n } = useTranslation();
    return (
        <div className="Footer_LanguageSelect">
            <span key="ru" className={i18n.language === "ru" ? "active" : ""} onClick={() => i18n.changeLanguage("ru")}>
                на русском
            </span>
            <span key="en" className={i18n.language === "en" ? "active" : ""} onClick={() => i18n.changeLanguage("en")}>
                in English
            </span>
        </div>
    );
}

function FooterVersion(props) {
    const { version } = props;
    return (
        <div className="Footer_version">
            {version && (
                <span>
                    Build
                    <br />
                    {version}
                </span>
            )}
        </div>
    );
}

function FooterApi(props) {
    const { apiVersion, apiBeta } = props;
    return (
        <div className="Footer_api">
            {apiVersion && (
                <span>
                    {apiVersion}
                    {apiBeta && <span className="Footer_api_beta">&beta;</span>}
                </span>
            )}
        </div>
    );
}

export default function Footer(props) {
    const { apiVersion, version } = props;
    const { t } = useTranslation("lib");

    return (
        <div className="Footer">
            <div key="left" className="Footer_left">
                <FooterVersion version={version} />
                <FooterApi apiVersion={apiVersion} />
                <a className="Footer_link" href="mailto:crypta@yandex-team.ru">
                    {t("footer.feedback")}
                </a>
                <LanguageSelect />
            </div>
            <div key="middle" className="Footer_middle">
                {t("footer.yandex_address")}
            </div>
            <div key="right" className="Footer_right">
                © 2000—{new Date().getFullYear()} &nbsp; {t("footer.yandex_llc")}
            </div>
        </div>
    );
}
