import React from "react";

import "./index.scss";

function isSafe(url) {
    if (url === null) {
        return true;
    }
    return url.hostname.endsWith("yandex-team.ru") || url.hostname.endsWith("yandex.ru");
}

function maybeUrl(href) {
    try {
        return new URL(href);
    } catch (_) {
        return null;
    }
}

function Link(props) {
    const { children, ...aProps } = props;
    const url = maybeUrl(aProps.href || "");
    if (!isSafe(url)) {
        aProps.href = "//h.yandex-team.ru/?" + encodeURI(url);
    }
    if (!aProps.rel) {
        aProps.rel = "noopener";
    }
    return <a {...aProps}>{props.children}</a>;
}

export default Link;
