import React from "react";
import PropTypes from "prop-types";
import { Spin } from "@lib/components/lego";

import "./index.scss";

function Loading(props) {
    const { loaded, size, children } = props;

    const isHuge = size === "huge";

    if (loaded) {
        return <div className="Loading-FadeIn">{children}</div>;
    } else {
        return (
            <div className="Loading-Spin">
                <div className={`Spinner${isHuge ? "-huge" : ""}`}>
                    <Spin progress size={size} view="default" />
                </div>
            </div>
        );
    }
}

Loading.propTypes = {
    loaded: PropTypes.bool.isRequired,
    size: PropTypes.oneOf(["huge", "l", "m", "s", "xs", "xxs"]),
    children: PropTypes.any.isRequired,
};

Loading.defaultProps = {
    size: "huge",
};

export default Loading;
