import React from "react";

import { useTranslation } from "react-i18next";

import logoEn from "@lib/images/logo_en.svg";
import logoRu from "@lib/images/logo_ru.svg";

import "./index.scss";

function CryptaLogo(props) {
    const { i18n } = useTranslation();
    return (
        <div className="crypta-logo">
            <a href="/">
                {i18n.language === "ru" ? (
                    <img className="logo-ru" alt="Yandex Crypta" src={logoRu} />
                ) : (
                    <img className="logo-en" alt="Yandex Crypta" src={logoEn} />
                )}
            </a>
        </div>
    );
}

export default CryptaLogo;
