import React from "react";
import { YMaps, Map as YMap, Placemark as YPlacemark } from "react-yandex-maps";

import "./index.scss";

export function pairToPoint(pair) {
    return {
        latitude: pair[0],
        longitude: pair[1],
    };
}

export function pointToPair(point) {
    return [point.latitude, point.longitude];
}

export function getCenter(points) {
    if (points.length === 0) {
        return [0, 0];
    }

    const latitudes = points.map((point) => point.latitude);
    const longitudes = points.map((point) => point.longitude);
    return {
        latitude:
            latitudes.reduce((a, b) => {
                return a + b;
            }, 0) / points.length,
        longitude:
            longitudes.reduce((a, b) => {
                return a + b;
            }, 0) / points.length,
    };
}

export function getRadius(points, center) {
    const ranges = points.map((point) => {
        return Math.sqrt(
            Math.pow(point.latitude - center.latitude, 2) + Math.pow(point.longitude - center.longitude, 2)
        );
    });
    return (
        ranges.reduce((a, b) => {
            return a + b;
        }, 0) / ranges.length
    );
}

export function getZoom(radius) {
    if (radius < 0.01) {
        return 15;
    } else if (radius >= 0.01 && radius < 0.05) {
        return 11;
    } else if (radius < 1 && radius >= 0.05) {
        return 10;
    } else if (3 > radius && radius >= 1) {
        return 9;
    } else if (4 > radius && radius >= 3) {
        return 6;
    } else if (radius >= 4) {
        return 4;
    }
    return 4;
}

export function Map(props) {
    const defaultState = {
        center: props.center,
        zoom: props.zoom,
    };
    return (
        <YMaps>
            <YMap className="Map" defaultState={defaultState}>
                {props.children}
            </YMap>
        </YMaps>
    );
}

export function Placemark(props) {
    return <YPlacemark {...props} />;
}
