import React, { useEffect, useState } from "react";
import FontAwesome from "react-fontawesome";
import { isEmpty } from "lodash";
import Link from "@lib/components/link";
import copyToClipboard from "@lib/utils/clipboard";
import { RedDot } from "@lib/components/color-dot";

import "./style.scss";

export function getLogLink(requestId, envType) {
    const logFilterTemplate = "request_id";

    return (
        "https://deploy.yandex-team.ru/stage/" +
        (envType === "production" ? "crypta-api" : "crypta-api-testing") +
        "/logs" +
        "?deploy-unit=api" +
        (isEmpty(requestId)
            ? ""
            : `&query=${logFilterTemplate}%3D${requestId}%3B%20`)
    );
}

const ErrorNotificationBody = (props) => {
    const { title, status, message, requestId, envType, t } = props;
    const [copied, setCopied] = useState(false);

    useEffect(() => {
        let timer1 = setTimeout(() => setCopied(false), 2000);
        return () => {
            clearTimeout(timer1);
        };
    }, [copied]);

    const logLink = getLogLink(requestId, envType);

    const copy = (what) => {
        copyToClipboard(what);
        setCopied(true);
    };

    return (
        <div className="ErrorNotificationBody">
            {title && (
                <div className="ErrorNotificationBody-title">{title}</div>
            )}
            <div className="ErrorNotificationBody-status-and-message">
                <RedDot />
                <span className="ErrorNotificationBody-status">{status}</span>
                <span className="ErrorNotificationBody-message">{message}</span>
            </div>

            {!isEmpty(requestId) && (
                <div className="ErrorNotificationBody-log-link">
                    <span className="ErrorNotificationBody-log-link-value">
                        <Link href={logLink} target="_blank">
                            {t("deployLogs")}
                        </Link>
                    </span>
                    <span className="ErrorNotificationBody-copy-link-icon">
                        <FontAwesome
                            name="copy"
                            onClick={() => copy(logLink)}
                            title={t("copyLink")}
                        />
                    </span>
                </div>
            )}
            {copied && <span className="CopiedFadeOut">{t("linkCopied")}</span>}
        </div>
    );
};

export { ErrorNotificationBody };
