import React, { Component } from "react";
import "./index.scss";

function formatTimeNumber(timeNumber) {
    return timeNumber < 10 ? "0" + timeNumber.toString() : timeNumber.toString();
}

export function formatDate(unixtime) {
    let date = new Date(unixtime * 1000);
    let year = date.getUTCFullYear().toString();
    let month = date.getUTCMonth() + 1;
    month = formatTimeNumber(month);
    let day = date.getUTCDate();
    day = formatTimeNumber(day);
    let hour = date.getUTCHours();
    hour = formatTimeNumber(hour);
    let minute = date.getUTCMinutes();
    minute = formatTimeNumber(minute);
    let second = date.getUTCSeconds();
    second = formatTimeNumber(second);
    return [[year, month, day].join("-"), [hour, minute, second].join(":"), "GMT"].join(" ");
}

export default class Index extends Component {
    constructor() {
        super();
        this.state = {
            forHuman: true,
            humanDate: undefined,
        };
    }

    componentDidMount() {
        this.setState({ humanDate: formatDate(this.props.value) });
    }

    componentWillReceiveProps(nextProps) {
        this.setState({ humanDate: formatDate(nextProps.value) });
    }

    handleClick() {
        this.setState({ forHuman: !this.state.forHuman });
    }

    render() {
        const valueHalfLength = Math.floor(this.props.value.toString().length / 2);
        const partOne = this.props.value.toString().substr(0, valueHalfLength);
        const partTwo = this.props.value.toString().substr(valueHalfLength);
        let displayable = this.state.forHuman ? (
            this.state.humanDate
        ) : (
            <div>
                {partOne}
                <wbr />
                {partTwo}
            </div>
        );

        return (
            <div className="optional-time" onClick={this.handleClick.bind(this)}>
                {displayable}
            </div>
        );
    }
}
