import React, { useEffect } from "react";
import Cookies from "universal-cookie";

import Link from "@lib/components/link";

import "./index.scss";

function getLoginFromCookie() {
    const cookies = new Cookies();
    return cookies.get("yandex_login");
}

function User(props) {
    const login = props.fromCookie ? getLoginFromCookie() : props.login || "unknown";
    const url = `https://center.yandex-team.ru/user/avatar/${login}/100/square`;
    const staffUrl = `https://staff.yandex-team.ru/${login}`;
    const style = { backgroundImage: `url(${url})` };
    return (
        <Link target="_blank" href={staffUrl}>
            <div className="User" style={style} />
        </Link>
    );
}

export default User;
