import React, { Component } from "react";
import * as Sentry from "@sentry/browser";
import Cookies from "universal-cookie";

import "./index.scss";

class SentryBoundary extends Component {
    constructor(props) {
        super(props);
        this.state = { eventId: null };
    }

    static getDerivedStateFromError() {
        return { hasError: true };
    }

    componentDidCatch(error, errorInfo) {
        Sentry.withScope((scope) => {
            scope.setExtras(errorInfo);
            const cookies = new Cookies();
            scope.setUser({
                id: cookies.get("yandexuid") || "",
                username: cookies.get("yandex_login") || "",
            });
            const eventId = Sentry.captureException(error);
            this.setState({ eventId });
        });
        Sentry.withScope((scope) => {
            scope.setExtras(errorInfo);
            const eventId = Sentry.captureException(error);
            this.setState({ eventId });
        });
    }

    render() {
        if (this.state.hasError) {
            //render fallback UI
            return (
                <div className="sentry-crash">
                    <span>:(</span>
                </div>
            );
        }
        //when there's not an error, render children untouched
        return this.props.children;
    }
}

export default SentryBoundary;
