export function downloadPlainTextFile(content, filename) {
    let blob = new Blob([content], { type: "text/plain;charset=utf-8;" });
    // IE11 & Edge
    if (navigator.msSaveBlob) {
        navigator.msSaveBlob(blob, filename);
    } else {
        // In FF link must be added to DOM to be clicked
        let link = document.createElement("a");
        link.href = window.URL.createObjectURL(blob);
        link.setAttribute("download", filename);
        document.body.appendChild(link);
        link.click();
        document.body.removeChild(link);
    }
}
