import Cookies from 'universal-cookie';

function getScript(id) {
    return `(function(m,e,t,r,i,k,a){m[i]=m[i]||function(){(m[i].a=m[i].a||[]).push(arguments)};
   m[i].l=1*new Date();k=e.createElement(t),a=e.getElementsByTagName(t)[0],k.async=1,k.src=r,a.parentNode.insertBefore(k,a)})
   (window, document, "script", "https://mc.yandex.ru/metrika/tag.js", "ym");

   ym(${id}, "init", {
        clickmap:true,
        trackLinks:true,
        accurateTrackBounce:true
   });`;
}

export function initializeMetrika(id) {
    const script = document.createElement("script");

    script.type = "text/javascript";
    script.innerHTML = getScript(id);
    script.async = true;

    document.body.appendChild(script);
    window.getMetrikaCounter = () => window["yaCounter" + id];
}

function reachGoalWithoutRetry(goal) {
    try {
        window.getMetrikaCounter().reachGoal(goal);
    } catch (error) {
        console.error("Failed to reach goal: " + error);
    }
}

export function reachGoal(goal) {
    if (!window.getMetrikaCounter) {
        setTimeout(() => reachGoalWithoutRetry(goal), 1000);
    } else {
        reachGoalWithoutRetry(goal);
    }
}

export function provideLoginUserId() {
    const cookies = new Cookies();
    const login = cookies.get("yandex_login", 'unknown')
    if (window.getMetrikaCounter) {
        window.getMetrikaCounter().userParams({ UserID: login });
    }
}
