function simpleFormatNumber(num) {
    // CAUTION: not suitable for big numbers

    if (!Number.isInteger(num) || num < 1000) {
        return num;
    }

    let numStr = num.toString();
    let l = numStr.length;
    let mainNumberLength = l % 3;
    mainNumberLength = mainNumberLength > 0 ? mainNumberLength : mainNumberLength + 3;

    let multiplier = Math.floor((l - mainNumberLength) / 3);
    let mainNumber = numStr.slice(0, mainNumberLength);

    if (multiplier === 1) {
        return mainNumber + "K";
    } else if (multiplier === 2) {
        return mainNumber + "M";
    } else if (multiplier === 3) {
        return mainNumber + "MM";
    } else {
        return "Unbelievable many";
    }
}

export { simpleFormatNumber };
