#!/bin/bash
export REGISTRY=registry.yandex.net/crypta/crypta-web-portal

set -e -o pipefail
set -x

cd "$(dirname "$0")"

ya package \
    --docker crypta-web-portal.json \
    --docker-network host \
    --docker-registry registry.yandex.net \
    --docker-repository crypta

docker image ls $REGISTRY
IMAGE=$(docker image ls $REGISTRY -q | head -1)

export CLIENT_ENV_API="https://api.crypta.yandex-team.ru/swagger.json"
export CLIENT_ENV_GRAB_URL="https://grab.crypta.yandex.ru"

# source ./env.sh &>/dev/null
docker run \
    --network host \
    -e CLIENT_ENV_API \
    -e CLIENT_ENV_GRAB_URL \
    -d $IMAGE

docker logs $(docker ps -q) -f
