import React, { useEffect } from "react";
import { isUndefined } from "lodash";
import { useSelector } from "react-redux";
import { Redirect, Route, Switch, withRouter } from "react-router-dom";

import AppHeader from "common/header/AppHeader.js";
import Banners from "ad/Banners";
import BbProfile from "src/bb-profile";
import Me from "src/me";
import Geo from "src/geo";
import Graph from "graph/Graph";
import Sbs from "src/sbs";
import MiniMe from "me/mini/MiniMe";
import { PublicInfo } from "./public-info/PublicInfo";
import { getPath, getSearch, getGrabId, getUid, getVersion } from "src/selectors";
import Notifications from "./utils/notifications/Notifications";

import Header from "@lib/components/header";
import Body from "@lib/components/body";
import Footer from "@lib/components/footer";
import { initializeMetrika } from "@lib/utils/metrika";

function goThroughRedirect(path, search) {
    window.location.href = "https://redirect.crypta.yandex.ru/" + window.location.hostname + path + search;
    return null;
}

function Layout(props) {
    const path = useSelector(getPath);
    const version = useSelector(getVersion);
    if (path !== "/mini" && path !== "/new") {
        return (
            <React.Fragment>
                <Header>
                    <AppHeader className="header" />
                </Header>
                <Body>{props.children}</Body>
                <Footer version={version} />
            </React.Fragment>
        );
    } else {
        return <React.Fragment>{props.children}</React.Fragment>;
    }
}

const App = (props) => {
    useEffect(() => {
        initializeMetrika(36655785);
    }, []);

    const path = useSelector(getPath);
    const search = useSelector(getSearch);
    const uid = useSelector(getUid);
    const grabId = useSelector(getGrabId);

    if (isUndefined(uid) && isUndefined(grabId)) {
        return goThroughRedirect(path, search);
    }
    let defaultRoute = () => <Redirect to={{ pathname: "/me", search: search }} />;

    return (
        <div className="App">
            <Layout>
                <Switch>
                    <Route exact path="/" render={defaultRoute} />
                    <Route exact path="/me" component={Me} />
                    <Route exact path="/ads" component={Banners} />
                    <Route exact path="/profiles" component={BbProfile} />
                    <Route exact path="/geo" component={Geo} />
                    <Route exact path="/graph" component={Graph} />
                    <Route exact path="/mini" component={MiniMe} />
                    <Route exact path="/sbs" component={Sbs} />
                    <Route exact path="/new" component={PublicInfo} />
                    <Route path="*" render={defaultRoute} />
                </Switch>
            </Layout>
            <Notifications />
        </div>
    );
};

export default withRouter(App);
