import { push, replace } from "connected-react-router";
import qs from "query-string";
import { getSearchObject } from "src/selectors/router";

export function reload() {
    return (dispatch) => {
        window.location.reload();
    };
}

export function setInQuery(key, value, refresh) {
    return (dispatch, getState) => {
        let search = getSearchObject(getState());
        search[key] = value;
        dispatch(push({ search: qs.stringify(search) }));
        if (refresh) {
            dispatch(reload());
        }
    };
}

export function setUid(uid) {
    return setInQuery("uid", uid, false);
}

export function dropQueryParam(key) {
    return (dispatch, getState) => {
        let search = getSearchObject(getState());
        delete search[key];

        dispatch(push({ search: qs.stringify(search) }));
    };
}

export function dropQueryWithoutReload() {
    return (dispatch) => {
        dispatch(replace({ search: "" }));
    };
}

export function dropQuery() {
    return (dispatch) => {
        dispatch(dropQueryWithoutReload());
        dispatch(reload());
    };
}
