import React, { Component } from "react";
import _ from "lodash";
import { connect } from "react-redux";
import FontAwesome from "react-fontawesome";
import { push } from "connected-react-router";

import ControlPanel from "../common/control-panel";
import AdditionalSettingsPanel from "../common/control-panel/AdditionalSettingsPanel";
import SelectUidType from "./SelectUidType";
import UidInput from "../common/UidInput";
import SelectUrlScheme from "./SelectUrlScheme";
import UrlInput from "./UrlInput";
import SelectPageIds from "./ad-controls/SelectPageIds";
import UserAgentInput from "./UserAgentInput";
import ImpIdInput from "./ad-controls/ImpIdInput";
import StatIdInput from "./ad-controls/StatIdInput";
import CharsetInput from "./CharsetInput";
import LayoutConfigInput from "./ad-controls/LayoutConfigInput";
import CallbackInput from "./CallbackInput";
import SkipBannerInput from "./ad-controls/SkipBannerInput";
import GrabInput from "./ad-controls/GrabInput";
import EnableFlatHighlightInput from "./EnableFlatHighlightInput";
import RegIdInput from "./RegIdInput";
import ActionButton from "../common/ActionButton";
import AdResponseTabs from "./AdResponseTabs";
import NotAuthorized from "../pages/NotAuthorized";
import SelectDebugMode from "./SelectDebugMode";
import ExperimentIdInput from "./ExperimentIdInput";
import BannerIdInput from "./BannerIdInput";
import QrModal from "./QrModal";
import UrlLink from "../common/links/UrlLink";
import { getGrabLink, getGrabResult } from "../utils/apiClient";
import LoadingSpinner from "../common/LoadingSpinner";
import Link from "@lib/components/link";

import { setInQuery, setUid } from "src/actions/router";
import { fetchPages } from "src/ad/pages/actions";
import { fetchAd } from "src/ad/ad/actions";
import { fetchDebugCookie } from "src/ad/debugCookie/actions";
import { getAdParameters } from "src/selectors/ad";
import { getUid, getUidType } from "src/selectors/uid";
import { getPath, getSearchObject } from "src/selectors/router";
import { addErrorNotification, dropAllNotifications } from "../utils/notifications/notificationsState";

import "./Banners.scss";

function sleep(ms) {
    return new Promise((resolve) => setTimeout(resolve, ms));
}

const GRAB_ID_QUERY_KEY = "grabId";

@connect(
    (state) => ({
        adParams: getAdParameters(state),
        pages: state.pages,
        debugCookie: state.debugCookie,
        uid: getUid(state),
        idType: getUidType(state),
        userAgent: state.ad.userAgent,
        search: getSearchObject(state),
        path: getPath(state),
        query: state.ad.query,
        ad: state.ad,
    }),
    (dispatch) => ({
        changeParameter: (key, value) => dispatch(setInQuery(key, value, false)),
        setUid: (uid) => dispatch(setUid(uid)),
        fetchPages: (url) => dispatch(fetchPages(url)),
        fetchAd: (uid, idType, debugCookie) => dispatch(fetchAd(uid, idType, debugCookie)),
        fetchDebugCookie: () => dispatch(fetchDebugCookie()),
        dispatch: dispatch,
    })
)
class Banners extends Component {
    constructor() {
        super();
        this.handleSelectUidType = this.handleSelectUidType.bind(this);
        this.handleUidInput = this.handleUidInput.bind(this);
        this.handleSelectUrlScheme = this.handleSelectUrlScheme.bind(this);
        this.handleUrlChange = this.handleUrlChange.bind(this);
        this.handlePageIdInputChange = this.handlePageIdInputChange.bind(this);
        this.handleUserAgentChange = this.handleUserAgentChange.bind(this);
        this.handleUserAgentSelect = this.handleUserAgentSelect.bind(this);
        this.handleImpIdChange = this.handleImpIdChange.bind(this);
        this.handleStatIdChange = this.handleStatIdChange.bind(this);
        this.handleCharsetChange = this.handleCharsetChange.bind(this);
        this.handleCallbackChange = this.handleCallbackChange.bind(this);
        this.handleLayoutConfigChange = this.handleLayoutConfigChange.bind(this);
        this.handleSkipBannerChange = this.handleSkipBannerChange.bind(this);
        this.handleGrabChange = this.handleGrabChange.bind(this);
        this.handleFlatHighlightChange = this.handleFlatHighlightChange.bind(this);
        this.handleRegIdChange = this.handleRegIdChange.bind(this);
        this.handleSelectDebugMode = this.handleSelectDebugMode.bind(this);
        this.handleGetAd = this.handleGetAd.bind(this);
        this.handleQrCodeRequest = this.handleQrCodeRequest.bind(this);
        this.handleExperimentIdChange = this.handleExperimentIdChange.bind(this);
        this.handleBannerIdChange = this.handleBannerIdChange.bind(this);
        this.handleEnterKeyPressedOnExpId = this.handleEnterKeyPressedOnExpId.bind(this);
        this.handleReloadPages = this.handleReloadPages.bind(this);

        this.state = {
            queryLink: "",
            authorized: true, // TODO: check auth in actions
            isWaitingForVisit: false,
            isQrModalOpen: false,
            viewerContentHeight: 0,
        };
    }

    componentDidUpdate(prevProps, prevState) {
        if (typeof this.state.newGrabId !== "undefined" && prevState.newGrabId !== this.state.newGrabId) {
            this.props.dispatch(push(`/ads?${GRAB_ID_QUERY_KEY}=${this.state.newGrabId}`));
        }

        let adContainerElement = document.getElementsByClassName("ad-container").item(0);
        let elementHeight = window.getComputedStyle(adContainerElement, null).getPropertyValue("height");
        elementHeight = parseFloat(elementHeight.substring(0, elementHeight.length - 2));

        if (prevState.viewerContentHeight !== elementHeight) {
            this.setState({ viewerContentHeight: elementHeight });
        }
    }

    componentDidMount() {
        // TODO: take out grab function to redux and then perform fetchAd
        let newState = Object.assign({}, this.state);

        this.props.changeParameter("userAgent", navigator.userAgent);

        const search = this.props.search;

        let { grabId } = search;

        if (!_.isEmpty(grabId)) {
            newState.isWaitingForVisit = false;
            newState.newGrabId = grabId;

            this.props.dispatch(dropAllNotifications());

            getGrabResult(grabId)
                .then((response) => {
                    const grabResult = response.obj;
                    const status = response.status;
                    if (status === 200) {
                        this.props.setUid(grabResult.yandexuid);
                        this.props.changeParameter("userAgent", grabResult.userAgent);
                        newState.isWaitingForVisit = false;
                        newState.isQrModalOpen = false;
                    }
                    this.setState(newState);
                })
                .catch((error) => {
                    if (error.status && error.status !== 404) {
                        this.props.dispatch(addErrorNotification(error, "Failed to capture device"));
                    }
                });
        }

        // TODO: find a better place for fetchPages
        this.props.fetchPages(this.props.adParams.url);
        this.setState(newState);

        this.props.fetchDebugCookie().then((response) => {
            this.props.fetchAd(this.props.uid, this.props.idType, response);
        });
    }

    async fetchGrabResult(grabId, initial = false) {
        let grabResult;
        let enough = false;
        let initial2 = initial;
        let newState = Object.assign({}, this.state);

        while ((enough !== true && this.state.isWaitingForVisit) || initial2) {
            initial2 = false;
            getGrabResult(grabId)
                .then((response) => {
                    grabResult = response.obj;
                    if (response.status === 200) {
                        enough = true;

                        this.props.dispatch(setUid(grabResult.yandexuid));
                        this.props.changeParameter("userAgent", grabResult.userAgent);
                        newState.isWaitingForVisit = false;
                        newState.isQrModalOpen = false;
                        this.setState(newState);
                    }
                })
                .catch((error) => {
                    console.error("Error fetching grab result:", error);
                    grabResult = "";
                });
            await sleep(2000);
        }
    }

    renderSelectUidType() {
        return <SelectUidType value={this.props.idType} onChange={this.handleSelectUidType} />;
    }

    handleSelectUidType(idType) {
        this.props.changeParameter("uidType", idType);
    }

    renderUidInput() {
        return <UidInput value={this.props.uid} onChange={this.handleUidInput} />;
    }

    handleUidInput(uidValue) {
        this.props.dispatch(setUid(uidValue));
    }

    renderSelectUrlScheme() {
        return <SelectUrlScheme value={this.props.adParams.scheme} onChange={this.handleSelectUrlScheme} />;
    }
    handleSelectUrlScheme(urlScheme) {
        this.props.changeParameter("scheme", urlScheme);
    }

    handleUrlChange(targetRef) {
        // TODO: think of auto loading ad after target ref changed
        if (targetRef !== "") {
            const cleanUrl = targetRef.trim().match(/([a-zA-Z0-9.-]+)/i)[0];

            if (cleanUrl !== null && this.props.adParams.url.trim() !== cleanUrl) {
                this.props.changeParameter("url", cleanUrl);
            }
        } else {
            this.props.changeParameter("url", targetRef);
        }
    }

    renderReloadPagesButton() {
        const displayTitle = <FontAwesome name="repeat" />;
        return (
            <div className="reload-page-ids-button">
                <ActionButton
                    onClick={() => this.handleReloadPages()}
                    title="Reload page ids"
                    displayTitle={displayTitle}
                />
            </div>
        );
    }
    handleReloadPages() {
        this.props.fetchPages(this.props.adParams.url);
    }

    renderSelectPageIds() {
        return (
            <SelectPageIds
                value={this.props.adParams.page}
                options={this.props.pages.values}
                onValueChange={(page) => this.handlePageIdInputChange(page)}
                onValueSelect={(page) => this.handlePageIdInputChange(page)}
            />
        );
    }

    handlePageIdInputChange(page) {
        this.props.changeParameter("page", page);
    }

    renderUserAgentInput() {
        return (
            <UserAgentInput
                value={this.props.adParams.userAgent}
                onValueChange={(value) => this.handleUserAgentChange(value)}
                onValueSelect={(value) => this.handleUserAgentSelect(value)}
            />
        );
    }
    handleUserAgentChange(userAgent) {
        this.props.changeParameter("userAgent", userAgent);
    }

    handleUserAgentSelect(userAgent) {
        this.props.changeParameter("userAgent", userAgent);
    }

    renderImpIdInput() {
        return <ImpIdInput value={this.props.adParams["imp-id"]} onChange={this.handleImpIdChange} />;
    }
    handleImpIdChange(impId) {
        this.props.changeParameter("imp-id", impId);
    }

    renderStatIdInput() {
        return <StatIdInput value={this.props.adParams["stat-id"]} onChange={this.handleStatIdChange} />;
    }
    handleStatIdChange(statId) {
        this.props.changeParameter("stat-id", statId);
    }

    renderCharsetInput() {
        return <CharsetInput value={this.props.adParams["charset"]} onChange={this.handleCharsetChange} />;
    }
    handleCharsetChange(charset) {
        this.props.changeParameter("charset", charset);
    }

    renderLayoutConfigInput() {
        return (
            <LayoutConfigInput value={this.props.adParams["layout-config"]} onChange={this.handleLayoutConfigChange} />
        );
    }
    handleLayoutConfigChange(layoutConfig) {
        this.props.changeParameter("layout-config", layoutConfig);
    }

    renderCallbackInput() {
        return <CallbackInput value={this.props.adParams["callback"]} onChange={this.handleCallbackChange} />;
    }
    handleCallbackChange(callback) {
        this.props.changeParameter("callback", callback);
    }

    renderSkipBannerInput() {
        return <SkipBannerInput value={this.props.adParams["skip-banner"]} onChange={this.handleSkipBannerChange} />;
    }
    handleSkipBannerChange(skipBanner) {
        this.props.changeParameter("skip-banner", skipBanner.replace(/\s/g, "\n"));
    }

    renderGrabInput() {
        return <GrabInput value={this.props.adParams["grab"]} onChange={this.handleGrabChange} />;
    }
    handleGrabChange(grab) {
        this.props.changeParameter("grab", grab);
    }

    renderEnableFlatHighlightInput() {
        return (
            <EnableFlatHighlightInput
                value={this.props.adParams["enable-flat-highlight"]}
                onChange={this.handleFlatHighlightChange}
            />
        );
    }
    handleFlatHighlightChange(flatHighlight) {
        this.props.changeParameter("enable-flat-highlight", flatHighlight);
    }

    renderRegIdInput() {
        return <RegIdInput value={this.props.adParams["tune-region-id"]} onChange={this.handleRegIdChange} />;
    }
    handleRegIdChange(regionId) {
        this.props.changeParameter("tune-region-id", regionId);
    }

    handleSelectDebugMode(debugMode) {
        new Promise((resolve, reject) => {
            this.props.changeParameter("debugMode", debugMode);
            resolve("done");
        }).then((done) => this.props.fetchAd(this.props.uid, this.props.idType, this.props.debugCookie.value));
    }

    renderGetAdButton() {
        const title = "Refresh ad";
        return (
            <div className="get-ad-button">
                <ActionButton onClick={() => this.handleGetAd()} title={title} displayTitle={title} />
            </div>
        );
    }
    handleGetAd() {
        this.props.fetchAd(this.props.uid, this.props.idType, this.props.debugCookie.value);
    }

    renderQueryLink() {
        const queryLink =
            this.props.path +
            "?" +
            Object.entries({
                ...this.props.adParams,
                uid: this.props.uid,
            })
                .map((paramPairs) => {
                    return paramPairs.join("=");
                })
                .join("&");

        return (
            <div style={{ marginTop: "20px" }}>
                <UrlLink type="share" theme="light" url={queryLink} text="Link" />
            </div>
        );
    }

    renderSelectDebugMode() {
        return <SelectDebugMode value={this.props.adParams.debugMode} onChange={this.handleSelectDebugMode} />;
    }

    handleQrCodeRequest() {
        getGrabLink().then((grabLink) => {
            this.setState(
                {
                    isQrModalOpen: true,
                    isWaitingForVisit: true,
                    qrLink: grabLink.url,
                    newGrabId: grabLink.grabId,
                },
                () => {
                    this.fetchGrabResult(grabLink.grabId);
                }
            );
        });
    }

    handleExperimentIdChange(expId) {
        this.props.changeParameter("experiment-id", expId);
    }

    handleBannerIdChange(expId) {
        this.props.changeParameter("aim-banner-id", expId);
    }

    handleEnterKeyPressedOnExpId() {
        console.log("Enter on exp id");
    }

    render() {
        const additionalSettings = (
            <div>
                <table>
                    <tbody>
                        <tr>
                            <td className="td-label">stat id</td>
                            <td>{this.renderStatIdInput()}</td>
                        </tr>
                        <tr>
                            <td className="td-label">charset</td>
                            <td>{this.renderCharsetInput()}</td>
                        </tr>
                        <tr>
                            <td className="td-label">callback</td>
                            <td>{this.renderCallbackInput()}</td>
                        </tr>
                        <tr>
                            <td className="td-label">tune-region-id</td>
                            <td>{this.renderRegIdInput()}</td>
                        </tr>
                        <tr>
                            <td className="td-label">enable-flat-highlight</td>
                            <td>{this.renderEnableFlatHighlightInput()}</td>
                        </tr>
                        <tr>
                            <td className="td-label">skip-banner</td>
                            <td colSpan={3}>{this.renderSkipBannerInput()}</td>
                        </tr>
                        <tr>
                            <td className="td-label">layout config</td>
                            <td colSpan={3}>{this.renderLayoutConfigInput()}</td>
                        </tr>
                        <tr>
                            <td className="td-label">grab</td>
                            <td colSpan={3}>{this.renderGrabInput()}</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        );

        const profile = this.state.authorized ? (
            <AdResponseTabs />
        ) : (
            <NotAuthorized
                text="Request Ad viewer role"
                roleLink={
                    "https://idm.yandex-team.ru/system/crypta/roles#rf=1,rf-role=GvyYuEZx#crypta/portal/ads" +
                    ";;;,f-status=all,f-role=crypta,sort-by=-updated,rf-expanded=GvyYuEZx"
                }
            />
        );

        let controls = (
            <div>
                <table>
                    <tbody>
                        <tr>
                            <td className="td-label">UniqID</td>
                            <td>{this.renderSelectUidType()}</td>
                            <td>{this.renderUidInput()}</td>
                        </tr>
                        <tr>
                            <td className="td-label">Target-Ref</td>
                            <td>{this.renderSelectUrlScheme()}</td>
                            <td>
                                <UrlInput
                                    value={this.props.adParams.url}
                                    onChange={(url) => this.handleUrlChange(url)}
                                    className="url-input"
                                />
                            </td>
                        </tr>
                        <tr>
                            <td className="td-label">
                                <div>{this.props.pages.isLoading ? <LoadingSpinner size="m" /> : ""} Page ID</div>
                            </td>
                            <td style={{ textAlign: "right" }}>{this.renderReloadPagesButton()}</td>
                            <td>{this.renderSelectPageIds()}</td>
                        </tr>
                        <tr>
                            <td className="td-label">
                                Imp ID
                            </td>
                            <td>{this.renderImpIdInput()}</td>
                        </tr>
                        <tr>
                            <td className="td-label">User Agent</td>
                            <td colSpan={2}>{this.renderUserAgentInput()}</td>
                        </tr>
                        <tr>
                            <td className="td-label">Experiment ID</td>
                            <td>
                                <ExperimentIdInput
                                    value={this.props.adParams["experiment-id"]}
                                    onChange={this.handleExperimentIdChange}
                                    handleEnterKeyPressed={() => this.handleEnterKeyPressedOnExpId()}
                                />
                            </td>
                        </tr>
                        <tr>
                            <td className="td-label">Banner ID</td>
                            <td>
                                <BannerIdInput
                                    value={this.props.adParams["aim-banner-id"]}
                                    onChange={this.handleBannerIdChange}
                                />
                            </td>
                        </tr>
                        <tr>
                            <td className="td-label">
                                Debug mode{" "}
                                <Link
                                    href="https://wiki.yandex-team.ru/bannernajakrutilka/otladochnajakuka/"
                                    target="blank_"
                                    className="wiki-link-debug-cookie"
                                >
                                    <FontAwesome name="question-circle" />
                                </Link>
                            </td>
                            <td colSpan="3">{this.renderSelectDebugMode()}</td>
                        </tr>
                        <tr>
                            <td />
                            <td colSpan={2}>
                                <div className="qr-and-ad-button">
                                    <div className="get-qr-button">
                                        <ActionButton
                                            onClick={() => this.handleQrCodeRequest()}
                                            title="Grab device"
                                            displayTitle={"Grab device"}
                                        />
                                    </div>
                                    {this.renderGetAdButton()}
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td style={{ textAlign: "center" }} colSpan={3}>
                                {this.renderQueryLink()}
                            </td>
                        </tr>
                    </tbody>
                </table>
                <AdditionalSettingsPanel content={additionalSettings} />
            </div>
        );

        return (
            <div className="ad-viewer-content">
                <ControlPanel
                    outerHeight={this.state.viewerContentHeight}
                    content={controls}
                    onRefresh={this.handleGetAd}
                />
                <div className="ad-container">
                    <QrModal
                        isOpen={this.state.isQrModalOpen}
                        onClose={() => {
                            this.setState({
                                isQrModalOpen: false,
                                isWaitingForVisit: false,
                            });
                        }}
                        isWaitingForVisit={this.state.isWaitingForVisit}
                        qrLink={this.state.qrLink}
                    />

                    <div className="ad-list-container">
                        <div>{profile}</div>
                    </div>
                </div>
            </div>
        );
    }
}

export default Banners;
