import React, { Component } from "react";
import { TextInput } from "@lib/components/lego";

import "./ExperimentIdInput.scss";

class ExperimentIdInput extends Component {
    constructor() {
        super();
        this.onEnterKeyPressed = this.onEnterKeyPressed.bind(this);
    }

    onEnterKeyPressed(event) {
        if (event.key === "Enter") {
            this.props.handleEnterKeyPressed();
        }
    }

    render() {
        return (
            <div className="experiment-id-input">
                <TextInput
                    view="default"
                    size="m"
                    placeholder="Experiment id"
                    value={this.props.value}
                    onKeyPress={this.onEnterKeyPressed}
                    onChange={(event) => this.props.onChange(event.target.value)}
                />
            </div>
        );
    }
}

export default ExperimentIdInput;
