import React, { Component } from "react";
import copyToClipboard from "@lib/utils/clipboard";
import { Modal } from "@lib/components/lego";
import { QRCode } from "react-qr-svg";

import ActionButton from "../common/ActionButton";
import LoadingSpinner from "../common/LoadingSpinner";

export default class QrModal extends Component {
    renderQrLink(qrLink) {
        return qrLink ? (
            <div className="qr-link">
                <QRCode bgColor="#FFFFFF" fgColor="#000000" level="Q" style={{ width: 300 }} value={qrLink} />
                <br />
                <div className="share-qr-button">
                    <ActionButton
                        onClick={() => {
                            copyToClipboard(qrLink);
                            alert("Copied");
                        }}
                        title="Copy link"
                        displayTitle={"Copy link"}
                        view="pseudo"
                    />
                </div>
                <div className="close-qr-button">
                    <ActionButton title="Close" displayTitle="Close" view="pseudo" onClick={this.props.onClose} />
                </div>
                <div className="qr-awaiting">
                    <LoadingSpinner /> Waiting for device to visit...
                </div>
            </div>
        ) : (
            <div />
        );
    }

    render() {
        return (
            <Modal theme="normal" zIndexGroupLevel={20} visible={this.props.isOpen} onClose={this.props.onClose}>
                {this.renderQrLink(this.props.qrLink)}
            </Modal>
        );
    }
}
