import React, { Component } from "react";
import { Select } from "@lib/components/lego";

const debugModeSimple = "SIMPLE";
const debugModeAdvanced = "ADVANCED";
const debugModeMx = "MX";

export default class SelectDebugMode extends Component {
    render() {
        return (
            <div className="select-debug-mode">
                <Select
                    width="max"
                    size="m"
                    view="default"
                    value={this.props.value}
                    onChange={(event) => this.props.onChange(event.target.value)}
                    options={[
                        { value: debugModeSimple, content: debugModeSimple },
                        { value: debugModeAdvanced, content: debugModeAdvanced },
                        { value: debugModeMx, content: debugModeMx },
                    ]}
                />
            </div>
        );
    }
}
