import React, { Component } from "react";
import Autosuggest from "react-autosuggest";

import "./SelectPageIds.scss";

class SelectPageIds extends Component {
    constructor() {
        super();
        this.onChange = this.onChange.bind(this);
        this.onSuggestionsFetchRequested = this.onSuggestionsFetchRequested.bind(this);
        this.renderInputComponent = this.renderInputComponent.bind(this);
        this.onSuggestionSelected = this.onSuggestionSelected.bind(this);
        this.onSuggestionsClearRequested = this.onSuggestionsClearRequested.bind(this);
        this.onEnterKeyPressed = this.onEnterKeyPressed.bind(this);

        this.state = {
            suggestions: [],
        };
    }

    getSuggestions(event, pages) {
        return pages.filter((page) => page.includes(event.value));
    }

    renderSuggestion(suggestion) {
        return <span>{suggestion}</span>;
    }

    renderInputComponent(inputProps) {
        return (
            <div>
                <input {...inputProps} />
                <span className="pageids-clear-button" onClick={() => this.props.onValueChange("")}>
                    ×
                </span>
            </div>
        );
    }

    onChange = (event, { newValue }) => this.props.onValueChange(newValue);

    onSuggestionSelected(event, { suggestion, suggestionValue, suggestionIndex, sectionIndex, method }) {
        this.props.onValueSelect(suggestionValue);
    }

    onEnterKeyPressed(event) {
        if (event.key === "Enter") {
            this.props.onValueSelect(event.target.value);
        }
    }

    onSuggestionsFetchRequested(value, pages) {
        this.setState({
            suggestions: this.getSuggestions(value, pages),
        });
    }

    onSuggestionsClearRequested() {
        this.setState({ suggestions: [] });
    }

    render() {
        const { value, options } = this.props;
        const suggestions = this.state.suggestions;

        const inputProps = {
            placeholder: "Page ID",
            value: value,
            onChange: this.onChange,
            onKeyPress: this.onEnterKeyPressed,
        };

        return (
            <Autosuggest
                multiSection={false}
                suggestions={suggestions}
                onSuggestionsFetchRequested={(value) => this.onSuggestionsFetchRequested(value, options)}
                onSuggestionsClearRequested={this.onSuggestionsClearRequested}
                onSuggestionSelected={this.onSuggestionSelected}
                shouldRenderSuggestions={() => {
                    return true;
                }}
                getSuggestionValue={(suggestion) => {
                    return suggestion;
                }}
                renderSuggestion={this.renderSuggestion}
                renderInputComponent={this.renderInputComponent}
                inputProps={inputProps}
            />
        );
    }
}

export default SelectPageIds;
