import { createAction } from "redux-actions";
import { getAdJson } from "src/utils/apiClient";
import { getAdParameters } from "src/selectors/ad";
import { addErrorNotification, dropAllNotifications } from "../../utils/notifications/notificationsState";

const requestAd = createAction("request ad");
const receiveAd = createAction("receive ad");

function fetchAd(uid, idType, debugCookie) {
    return function (dispatch, getState) {
        let params = getAdParameters(getState());
        let { page, userAgent, debugMode } = params;

        let queryParams = {
            "stat-id": params["stat-id"],
            "imp-id": params["imp-id"],
            charset: params["charset"],
            callback: params["callback"],
            "tune-region-id": params["tune-region-id"],
            "enable-flat-highlight": params["enable-flat-highlight"],
            "skip-banner": params["skip-banner"],
            "layout-config": params["layout-config"],
            grab: params["grab"],
            "experiment-id": params["experiment-id"],
            "target-ref": [params.scheme, params.url].join("://"),
            "aim-banner-id": params["aim-banner-id"],
        };

        dispatch(dropAllNotifications());
        dispatch(requestAd());

        let urlQueryParams = JSON.stringify(queryParams);
        return getAdJson(page, urlQueryParams, uid, idType, userAgent, debugCookie, debugMode)
            .then((response) => {
                let ad = {};
                if (response) {
                    ad = response.obj;
                }

                dispatch(receiveAd(ad));
            })
            .catch((error) => {
                console.error("Unable to fetch ad:", error);
                if (error.status && error.status !== 404) {
                    dispatch(addErrorNotification(error, "Faile to fetch ad"));
                }

                dispatch(receiveAd({}));
            });
    };
}

export { requestAd, receiveAd, fetchAd };
