import { createAction } from "redux-actions";
import { updateDebugCookie } from "src/utils/apiClient";
import { addErrorNotification, dropAllNotifications } from "../../utils/notifications/notificationsState";

const requestCookie = createAction("debug cookie requested");
const receiveCookie = createAction("debug cookie received");

export function fetchDebugCookie() {
    return function (dispatch) {
        dispatch(dropAllNotifications());
        dispatch(requestCookie());

        return updateDebugCookie()
            .then((response) => {
                let cookie = "";
                if (response) {
                    cookie = response.data.replace(/"/g, "");
                }

                dispatch(receiveCookie(cookie));
                return cookie;
            })
            .catch((error) => {
                console.error("Error fetching debug cookie:", error);
                if (error.status && error.status !== 404) {
                    dispatch(addErrorNotification(error, "Fetching debug cookie failed"));
                }
            });
    };
}

export { requestCookie, receiveCookie };
