import { handleActions } from "redux-actions";
import { receiveCookie, requestCookie } from "src/ad/debugCookie/actions";

const DEFAULT_STATE = {
    isFetching: false,
    didFetch: false,
    value: "",
};

export const debugCookie = handleActions(
    {
        [requestCookie]: (state) => ({
            ...state,
            isFetching: true,
            didFetch: false,
        }),
        [receiveCookie]: (state, { payload }) => ({
            ...state,
            isFetching: false,
            didFetch: true,
            value: payload,
        }),
    },
    DEFAULT_STATE
);
