import { createAction } from "redux-actions";
import { getPageIds } from "src/utils/apiClient";
import { addErrorNotification, dropAllNotifications } from "../../utils/notifications/notificationsState";

const requestPages = createAction("pages requested");
const receivePages = createAction("pages received");

function fetchPages(url) {
    return function (dispatch) {
        dispatch(dropAllNotifications());
        dispatch(requestPages(url));
        return getPageIds(url)
            .then((response) => {
                let pages = [];
                if (response) {
                    pages = response.obj;
                }

                dispatch(receivePages(pages));
            })
            .catch((error) => {
                console.error("Unable to fetch pages", error);
                if (error.status && error.status !== 404) {
                    dispatch(addErrorNotification(error, "Fetching pages failed"));
                }
                dispatch(receivePages([]));
            });
    };
}

export { requestPages, receivePages, fetchPages };
