import { handleActions } from "redux-actions";
import { receivePages, requestPages } from "src/ad/pages/actions";

const defaultState = {
    values: [],
    isLoading: false,
};

export const pages = handleActions(
    {
        [requestPages]: (state, { payload }) => ({
            ...state,
            url: payload,
            isLoading: true,
        }),
        [receivePages]: (state, { payload }) => ({
            ...state,
            values: payload,
            isLoading: false,
        }),
    },
    defaultState
);
