import { createAction } from "redux-actions";
import _ from "lodash";
import { getSearchTextWithMatching } from "../../utils/apiClient";
import { getUid } from "selectors";
import { addErrorNotification } from "../../utils/notifications/notificationsState";

const requestSearchTextMatched = createAction("search text with matching requested");
const receiveSearchTextMatched = createAction("search text with matching received");

export function fetchSearchText(uidType = "BIGB_UID", uid) {
    return function (dispatch) {
        dispatch(requestSearchTextMatched(uid));

        return getSearchTextWithMatching(uidType, uid)
            .then((response) => {
                let searchText = {};
                if (response) {
                    searchText = response.obj;
                }

                dispatch(receiveSearchTextMatched(searchText));
            })
            .catch((error) => {
                if (error.status && error.status !== 404) {
                    dispatch(addErrorNotification(error, "Fetching user ad failed"));
                }
            });
    };
}

function shouldFetchSearchText(state) {
    if (getUid(state) === "") {
        return false;
    } else if (state.searchText.isFetching) {
        return false;
    } else {
        return _.isEmpty(state.searchText.value) && !state.searchText.isReady;
    }
}

export function fetchSearchTextMatchedIfNeeded(uidType = "BIGB_UID", uid) {
    return function (dispatch, getState) {
        if (shouldFetchSearchText(getState())) {
            dispatch(fetchSearchText(uidType, uid));
        } else {
            return Promise.resolve();
        }
    };
}

export { requestSearchTextMatched, receiveSearchTextMatched };
