import { handleActions } from "redux-actions";
import { receiveSearchTextMatched, requestSearchTextMatched } from "src/ad/searchText/actions";

const DEFAULT_STATE = {
    value: {},
    isFetching: false,
    isReady: false,
};

export const searchText = handleActions(
    {
        [requestSearchTextMatched]: (state) => ({
            ...state,
            isFetching: true,
            isReady: false,
        }),
        [receiveSearchTextMatched]: (state, { payload }) => ({
            ...state,
            value: payload,
            isFetching: false,
            isReady: true,
        }),
    },
    DEFAULT_STATE
);
