import { createAction } from "redux-actions";
import { getSelectTypes } from "src/utils/apiClient";
import _ from "lodash";

const requestSelectTypes = createAction("selectTypes requested");
const receiveSelectTypes = createAction("selectTypes received");
const failSelectTypes = createAction("selectTypes failed");

export function fetchSelectTypes() {
    return (dispatch) => {
        dispatch(requestSelectTypes());
        getSelectTypes()
            .then((response) => {
                let selectTypes = {};

                if (response) {
                    response.forEach((item) => {
                        selectTypes[item.selectType.toString()] = {
                            description: item.description,
                            weight: item.weight,
                        };
                    });
                }

                dispatch(receiveSelectTypes(selectTypes));
            })
            .catch((error) => {
                dispatch(failSelectTypes());
            });
    };
}

export { requestSelectTypes, receiveSelectTypes, failSelectTypes };
