import { handleActions } from "redux-actions";
import { failSelectTypes, receiveSelectTypes, requestSelectTypes } from "src/ad/selectTypes/actions";

export const selectTypes = handleActions(
    {
        [requestSelectTypes]: (state) => ({
            ...state,
            isFetching: true,
            error: false,
        }),
        [receiveSelectTypes]: (state, { payload }) => ({
            ...state,
            items: payload,
            isFetching: false,
        }),
        [failSelectTypes]: (state) => ({
            ...state,
            items: {},
            isFetching: false,
            error: true,
        }),
    },
    {
        items: {},
        isFetching: false,
        error: false,
    }
);
