import { createAction } from "redux-actions";
import { getUserAgents } from "src/utils/apiClient";

const requestUserAgents = createAction("user agents requested");
const receiveUserAgents = createAction("user agents received");

function fetchUserAgents() {
    return function (dispatch) {
        dispatch(requestUserAgents());

        return getUserAgents().then((response) => {
            dispatch(receiveUserAgents(response));
        });
    };
}

const shouldFetchUserAgents = (state) => {
    const useragents = state.userAgents.items;
    return Object.keys(useragents).length === 0;
};

const fetchUserAgentsIfNeeded = () => (dispatch, getState) => {
    if (shouldFetchUserAgents(getState())) {
        return dispatch(fetchUserAgents());
    }
};

export { requestUserAgents, receiveUserAgents, fetchUserAgentsIfNeeded };
