import { handleActions } from "redux-actions";
import { receiveUserAgents, requestUserAgents } from "src/ad/useragent/actions";

const DEFAULT_STATE = {
    items: {},
    isFetching: false,
};

export const userAgents = handleActions(
    {
        [requestUserAgents]: (state) => ({
            ...state,
            isFetching: true,
        }),
        [receiveUserAgents]: (state, { payload }) => ({
            ...state,
            items: payload,
            isFetching: false,
        }),
    },
    DEFAULT_STATE
);
